/*----------------------------------------------------------------------------*\
     This is a lib which reads 3d-studio binary files from version 3.0
     and higher
     (v1.05)
     author: Martin van Velsen
             ( and some great help by Gert van der Spoel )
     email:  vvelsen@ronix.ptf.hro.nl

     If you happen to come across some variables with strange names, then
     that will possible be Dutch names, sorry for that :)
\*----------------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

//>------ Id Chunk

#define MAIN3DS       0x4D4D

//>------ Main Chunks

#define EDIT3DS       0x3D3D  // this is the start of the editor config
#define KEYF3DS       0xB000  // this is the start of the keyframer config

//>------ sub defines of EDIT3DS

#define EDIT_MATERIAL 0xAFFF
#define EDIT_CONFIG1  0x0100
#define EDIT_VERSION1 0x0002
#define EDIT_VERSION2 0x3D3E
#define EDIT_VIEW_P1  0x7012
#define EDIT_VIEW_P2  0x7011
#define EDIT_VIEW_P3  0x7020
#define EDIT_VIEW1    0x7001
#define EDIT_BACKGR   0x1200
#define EDIT_AMBIENT  0x2100
#define EDIT_OBJECT   0x4000

#define EDIT_UNKNW01  0x1100
#define EDIT_UNKNW02  0x1201
#define EDIT_UNKNW03  0x1300
#define EDIT_UNKNW04  0x1400
#define EDIT_UNKNW05  0x1420
#define EDIT_UNKNW06  0x1450
#define EDIT_UNKNW07  0x1500
#define EDIT_UNKNW08  0x2200
#define EDIT_UNKNW09  0x2201
#define EDIT_UNKNW10  0x2210
#define EDIT_UNKNW11  0x2300
#define EDIT_UNKNW12  0x2302 // new chunk type
#define EDIT_UNKNW13  0x3000

//>------ sub defines of EDIT_MATERIAL

#define MAT_NAME01    0xA000  //> includes name (see mli doc for materials)
#define MAT_AMBIENT   0xA010
#define MAT_DIFFUSE   0xA020
#define MAT_SPECULAR  0xA030
#define MAT_SHININESS 0xA040
#define MAT_SHINSTEN  0xA041
#define MAT_TRANSPAR  0xA050
#define MAT_TRANSFALL 0xA052
#define MAT_REFLECT	  0xA053
#define MAT_SELFILLUM 0xA084
#define MAT_TYPE	  0xA100

#define MAT_RGB1	  0x0011 //followed by chunc size and 3xBYTEs
#define MAT_RGB2	  0x0012 //3xBYTEs (smaller twice????)

#define MAT_PARAMVALUE 0xA252

#define MAT_TXT1_MAP  0xA200
#define MAT_TXT2_MAP  0xA33A
#define MAT_OPAC_MAP  0xA210
#define MAT_BUMP_MAP  0xA230
#define MAT_SPEC_MAP  0xA204
#define MAT_SHIN_MAP  0xA33C
#define MAT_ILLU_MAP  0xA33D
#define MAT_REFL_MAP  0xA220

#define MAT_TXT1_MASK 0xA33E
#define MAT_TXT2_MASK 0xA340
#define MAT_OPAC_MASK 0xA342
#define MAT_BUMP_MASK 0xA344
#define MAT_SPEC_MASK 0xA348
#define MAT_SHIN_MASK 0xA346
#define MAT_ILLU_MASK 0xA34A
#define MAT_REFL_MASK 0xA34C

#define MAT_MAPAMOUNT 0x0030
#define MAT_MAPFILE   0xA300
#define MAT_MAPOPT    0xA351
#define MAT_MAPFILTER 0xA353


#define MAT_MAPUSCELE   0xA354// * float    1/U scale
#define MAT_MAPVSCALE   0xA356// * float    1/V scale
#define MAT_MAPUOFFSET  0xA358// * float    U offset
#define MAT_MAPVOFFSET  0xA35A// * float    V offset
#define MAT_MAPROTATION 0xA35C// * float    map rotation angle
#define MAT_MAPTINTCOL1 0xA360// * RGB      lum or alpha tint first color (default=00 00 00)
#define MAT_MAPTINTCOL2 0xA362// * RGB      lum or alpha tint secnd color (default=FF FF FF)
#define MAT_MAPTINTCOLR 0xA364// * RGB      RGB tint R channel color (default=FF 00 00)
#define MAT_MAPTINTCOLG 0xA366// * RGB      RGB tint G channel color (default=00 FF 00)
#define MAT_MAPTINTCOLB 0xA368// * RGB      RGB tint B channel color (default=00 00 FF)

//>------ sub defines of EDIT_OBJECT

#define OBJ_TRIMESH   0x4100
#define OBJ_LIGHT     0x4600
#define OBJ_CAMERA    0x4700

#define OBJ_UNKNWN01  0x4010
#define OBJ_UNKNWN02  0x4012 //>>---- Could be shadow

//>------ sub defines of OBJ_CAMERA
#define CAM_UNKNWN01  0x4710 // new chunk type
#define CAM_UNKNWN02  0x4720 // new chunk type

//>------ sub defines of OBJ_LIGHT
#define LIT_OFF       0x4620
#define LIT_SPOT      0x4610
#define LIT_UNKNWN01  0x465A

//>------ sub defines of OBJ_TRIMESH
#define TRI_VERTEXL   0x4110
#define TRI_FACEL2    0x4111 // unknown yet....
#define TRI_FACEL1    0x4120
#define TRI_FACEMAT   0x4130

#define TRI_FACEUV    0x4140

#define TRI_SMOOTH    0x4150//Really???
#define TRI_LOCAL     0x4160
#define TRI_VISIBLE   0x4165

//>>------ sub defs of KEYF3DS

#define KEYF_UNKNWN01 0xB009
#define KEYF_UNKNWN02 0xB00A
#define KEYF_FRAMES   0xB008
#define KEYF_OBJDES   0xB002

#define KEYF_OBJHIERARCH  0xB010
#define KEYF_OBJDUMMYNAME 0xB011
#define KEYF_OBJUNKNWN01  0xB013
#define KEYF_OBJUNKNWN02  0xB014
#define KEYF_OBJUNKNWN03  0xB015  
#define KEYF_OBJPIVOT     0xB020  
#define KEYF_OBJUNKNWN04  0xB021  
#define KEYF_OBJUNKNWN05  0xB022  

//>>------  these define the different color chunk types
#define COL_RGB  0x0010
#define COL_TRU  0x0011
#define COL_UNK  0x0013 // unknown

//>>------ defines for viewport chunks

#define TOP           0x0001
#define BOTTOM        0x0002
#define LEFT          0x0003
#define RIGHT         0x0004
#define FRONT         0x0005
#define BACK          0x0006
#define USER          0x0007
#define CAMERA        0x0008 // 0xFFFF is the code read from file
#define LIGHT         0x0009
#define DISABLED      0x0010
#define BOGUS         0x0011


//>------ typedefs
typedef struct RGBBYTE
{
	BYTE r,g,b;
}RGBBYTE;


typedef struct MapDescriptor
{
	WORD	Amount;
	char	Filename[255];
	WORD	Options;
	float	Blur, UScale, VScale, UOffset, VOffset, Rotation;
	RGBBYTE	TintCol1,TintCol2,TintColR,TintColG,TintColB;

	MapDescriptor()
	{
		for (int i = 0; i < 255; i++)
			Filename[i] = 0;
		Amount = 0;
		Options =0;
		Blur = 0.0f;
		UScale = 1.0f;
		VScale = 1.0f;
		UOffset= 0.0f;
		VOffset= 0.0f;
		Rotation=0.0f;
	}
}MapDescriptor;


typedef struct Material
{
	char Name[255];
	RGBBYTE AmbiCol;
	RGBBYTE DiffCol;
	RGBBYTE SpecCol;
	WORD	Shine,
			ShinStren,
			Transpar,
			TransFalloff,
			Reflect,
			SelfIllum;

	MapDescriptor
			Textur1Map,
			Textur2Map,
			OpacityMap,
			BumpMap,
			SpecMap,
			ShinMap,
			SelfMap,
			RefMap,
			Textur1Mask,
			Textur2Mask,
			OpacityMask,
			BumpMask,
			SpecMask,
			ShinMask,
			SelfMask,
			RefMask;
}Material;

typedef struct MaterialsList
{
	char			Name[255];
	DWORD			IndexInZMatSet;
	Material		mat;
	MaterialsList*	Next;
}MaterialsList;
